ORCA/M Asm65816 2.1.0

0001 134C              *******************************************************************************
0002 134C              *
0003 134C              * Initialization for Fast text caching routines...
0004 134C              *
0005 134C              * (C)  Copyright Apple Computer, Inc. 1989, 1992
0006 134C              * All rights reserved.
0007 134C              *
0008 134C              * by Jim Mensch
0009 134C              * 2/7/89
0010 134C              *
0011 134C              *******************************************************************************
0012 134C              *
0013 134C              * Modification History:
0014 134C              *
0015 134C              * Version 1.0       mensch 2/7/89
0016 134C              *
0017 134C              * 15 Mar 89         Steven Glass
0018 134C              *
0019 134C              * A little clean up so it can be used in both the patch and the ROM.
0020 134C              *
0021 134C              *******************************************************************************
0022 134C
0023 134C              *******************************************************************************
0024 134C              *
0025 134C              DoFastSetup PROC export
0026 134C              *
0027 134C              * This routine does all the necessary setup to use a fast system font.
0028 134C              *
0029 134C              * First it looks for the FastFont in memory.  It is kept in a handle which
0030 134C              * is kept in a new message.
0031 134C              *
0032 134C              * If the message exists, then we look at the font handle.  It may have
0033 134C              * been purged.  A purged handle means that we have to start over as
0034 134C              * if the handle was not there at all.
0035 134C              *
0036 134C              * If the message does not exist or the font has been purged, then
0037 134C              * we look for the font on disk.  If it's there we get memory for it
0038 134C              * and read it in.
0039 134C              *
0040 134C              * Finally we create the message for the fast font so that the next
0041 134C              * time it can be there.
0042 134C              *
0043 134C              *
0044 134C              * Inputs:           Stack:  Room for result
0045 134C              *                   a-reg   QuickDraw's DPage
0046 134C              *
0047 134C              * Outputs:          Stack:  Handle
0048 134C              *                   a-reg   QuickDraw's DPage
0049 134C              *
0050 134C              * External Refs:
0051 134C              *                   none
0052 134C              *
0053 134C              * Entry Points:
0054 134C              *                   none
0055 134C              *
0056 134C              *******************************************************************************
0057 134C                       DefineStack 
0058 134C              deref1   long 
0059 134C              tempPort long 
0060 134C              tempHandle long 
0061 134C              RefNum   word 
0062 134C              FileSize word 
0063 134C              ;
0064 134C              SaveDPage word 
0065 134C              QDDPage  word 
0066 134C              RTL1     block 3
0067 134C              Result   long 
0068 134C
0069 134C              SizeOfFrame equ   SaveDPage-deRef1
0070 134C
0071 134C              ;
0072 134C              ; Equates for the fastfont record
0073 134C              ;
0074 134C              o_FFAscent equ   0
0075 134C              o_FFDescent equ   o_FFAscent+2
0076 134C              o_FFMaxWidth equ   o_FFDescent+2
0077 134C              o_Leading equ   o_FFMaxWidth+2
0078 134C              o_FFrowBytes equ   o_Leading+2
0079 134C              o_oldFontHandle equ   o_FFRowBytes+2
0080 134C              o_StrikeSize equ   o_oldFontHandle+4
0081 134C              o_FFSizeofVars equ   o_StrikeSize+4
0082 134C              o_FFWidthTable equ   o_FFSizeofVars
0083 134C              o_FFOffsetTable equ   o_FFWidthTable+256
0084 134C              o_FFEndOfTables equ   o_FFOffsetTable+512
0085 134C              ;
0086 134C              ; MessageCenterEquates
0087 134C              FFHandleMessage equ   35                ; message number that will contain our fastfont handle
0088 134C              FFMessageSize equ   8                   ; it will be 8 bytes long just in case..
0089 134C              FFMessageIndicator equ   $A5E7          ; just a byte that indicates the message is ok..
0090 134C              FFID     equ   $4404                    ; memory ID we use to create handle here.
0091 134C
0092 134C
0093 134C
0094 134C 48                    pha   
0095 134D 0B                    phd   
0096 134E 5B                    tcd                            ; switch in qddpage for a moment to clear handle
0097 134F A2 00 02              ldx   #512                     ; first thing we do is zero out the old fastfontptr
0098 1352 74 F0                 stz   <FastRomFont,x
0099 1354 74 F2                 stz   <FastRomFont+2,x
0100 1356 3B                    tsc                            ; get the stack pointer
0101 1357
0102 1357 38                    sec   
0103 1358 E9 10 00              sbc   #SizeOfFrame
0104 135B 5B                    tcd                            ; create the stack frame...
0105 135C 1B                    tcs   
0106 135D              ;
0107 135D              ; Now that the stack frame is set up, create the offscreen buffers that we are
0108 135D              ; going to use. Ask for a block the size of shaston 8 first!
0109 135D              ;
0110 135D 64 18                 stz   Result
0111 135F 64 1A                 stz   Result+2
0112 1361
0113 1361 20 4B 14              jsr   GetMessage               ; first see if the fastfont is in memory already
0114 1364 B0 0E                 bcs   @NotLoaded               ; if carry set, the fastfont ain't here yet..
0115 1366
0116 1366 85 18                 sta   Result
0117 1368 8A                    txa   
0118 1369 09 00 80              ora   #$8000
0119 136C 85 1A                 sta   Result+2
0120 136E A2 00 00              ldx   #0
0121 1371 82 CA 00              brl   @okEnd
0122 1374              @NotLoaded  
0123 1374
0124 1374              ;
0125 1374              ; Open the File
0126 1374              ;
0127 1374 A9 00 00              lda   #0
0128 1377 48                    pha                            ; room for refnum
0129 1378 48                    pha   
0130 1379 F4 FE 00 F4           PushLong #FFPath 
0131 137F 48                    pha   
0132 1380 3B                    tsc   
0133 1381 F4 00 00              pea   00
0134 1384 1A                    inc   a
0135 1385 48                    pha   
0136 1386 F4 10 00              pea   $0010                    ;OPEN
0137 1389 22 B0 00 E1           jsl   >$E100B0
0138 138D AA                    tax   
0139 138E 68                    pla                            ; save the refnum
0140 138F 7A                    ply   
0141 1390 7A                    ply   
0142 1391 7A                    ply   
0143 1392 7A                    ply                            ; discard the crap
0144 1393 90 03 82 A6           bcsl @QuickExit
0145 1398 85 0D                 sta   refNum
0146 139A
0147 139A              ;
0148 139A              ; Get the file size
0149 139A              ;
0150 139A 48                    pha                            ; space for eof
0151 139B 48                    pha   
0152 139C D4 0D                 pei   refNum                   ; the ref num
0153 139E 3B                    tsc                            ; pointer to param block
0154 139F F4 00 00              pea   00
0155 13A2 1A                    inc   a
0156 13A3 48                    pha   
0157 13A4 F4 19 00              pea   $19                      ;GET_EOF
0158 13A7 22 B0 00 E1           jsl   >$E100B0
0159 13AB 68                    pla   
0160 13AC 68                    pla   
0161 13AD FA                    plx   
0162 13AE 85 0F                 sta   FileSize                 ; save this here
0163 13B0 B0 45                 bcs   @QuickError              ; Close file and get out on error
0164 13B2
0165 13B2              ;
0166 13B2              ; Now get memory for the file
0167 13B2              ;
0168 13B2
0169 13B2 A2 08 80              ldx   #attrLocked+attrNoSpec   ; start it out locked.
0170 13B5 20 49 15              jsr   GetALittleMem
0171 13B8 90 03 82 3A           bcsl @QuickError               ; close file and get out  on error
0172 13BD
0173 13BD 85 01                 sta   deRef1
0174 13BF 85 18                 sta   Result
0175 13C1 8A                    txa   
0176 13C2 09 00 80              ora   #$8000
0177 13C5 85 03                 sta   deRef1+2
0178 13C7 85 1A                 sta   Result+2
0179 13C9
0180 13C9              ;
0181 13C9              ; Deref the handle in place (Pointer goes to deRef1).
0182 13C9              ;
0183 13C9 A0 02 00              ldy   #2                       ; Deref handle and put pointer in deref1
0184 13CC B7 01                 lda   [deref1],y
0185 13CE AA                    tax   
0186 13CF A7 01                 lda   [deref1]
0187 13D1 85 01                 sta   deref1
0188 13D3 86 03                 stx   deref1+2
0189 13D5
0190 13D5              ;
0191 13D5              ; Read the data
0192 13D5              ;
0193 13D5 A9 00 00              lda   #0
0194 13D8 48                    pha   
0195 13D9 48                    pha   
0196 13DA 48                    pha   
0197 13DB D4 0F                 pei   FileSize
0198 13DD D4 03                 pei   deref1+2
0199 13DF D4 01                 pei   deref1
0200 13E1 D4 0D                 pei   refnum
0201 13E3 3B                    tsc   
0202 13E4 F4 00 00              pea   00
0203 13E7 1A                    inc   a
0204 13E8 48                    pha   
0205 13E9 F4 12 00              pea   $0012                    ;READ
0206 13EC 22 B0 00 E1           jsl   >$E100B0
0207 13F0 FA                    plx   
0208 13F1 FA                    plx   
0209 13F2 FA                    plx   
0210 13F3 FA                    plx   
0211 13F4 FA                    plx   
0212 13F5 FA                    plx   
0213 13F6 FA                    plx   
0214 13F7
0215 13F7              ;
0216 13F7              ; Come here if error occurs after open.
0217 13F7              ;
0218 13F7 08           @QuickError php                         ; save the read status, it's important
0219 13F8
0220 13F8              ;
0221 13F8              ; Close the file.
0222 13F8              ;
0223 13F8 D4 0D                 pei   refnum
0224 13FA 3B                    tsc   
0225 13FB F4 00 00              pea   00
0226 13FE 1A                    inc   a
0227 13FF 48                    pha   
0228 1400 F4 14 00              pea   $0014                    ;CLOSE
0229 1403 22 B0 00 E1           jsl   >$E100B0
0230 1407 68                    pla   
0231 1408
0232 1408              ;
0233 1408              ; Now see if everything worked or not.
0234 1408              ;
0235 1408 28                    plp   
0236 1409 A2 FF FF              ldx   #-1
0237 140C B0 20                 bcs   @ErrOut                  ; carry set means it did not work
0238 140E
0239 140E              ;
0240 140E              ; Put the handle to the real system font into place.  Make this stuff work right!
0241 140E              ;
0242 140E A0 0A 00              ldy   #o_oldFontHandle
0243 1411 A9 1B DD              lda   #SystemFont
0244 1414 97 01                 sta   [deref1],y
0245 1416 A9 FC 00              lda   #^SystemFont
0246 1419 A0 0C 00              ldy   #o_oldFontHandle+2
0247 141C 97 01                 sta   [Deref1],y
0248 141E
0249 141E              ;
0250 141E              ; Unlock the fast font handle
0251 141E              ;
0252 141E A0 04 00              ldy   #4
0253 1421 B7 18                 lda   [Result],y
0254 1423 29 FF 7F              and   #$7FFF
0255 1426 97 18                 sta   [Result],y
0256 1428
0257 1428 20 DA 14              jsr   sendMessage              ; if we get this far, post our little message...
0258 142B A2 00 00              ldx   #0
0259 142E
0260 142E              @ErrOut   
0261 142E E0 00 00              cpx   #0                       ; if x is zero we are safe
0262 1431 F0 0B                 beq   @okend
0263 1433 A5 1A                 lda   Result+2                 ; it was not zero so kill the allocated handle
0264 1435 29 FF 00              and   #$00FF
0265 1438 AA                    tax   
0266 1439
0267 1439 A5 18                 lda   Result
0268 143B 20 3F 15              jsr   KillIt
0269 143E
0270 143E              @QuickExit                              ; finally!
0271 143E
0272 143E 7B           @okEnd   tdc   
0273 143F 18                    clc   
0274 1440 69 10 00              adc   #SizeOfFrame
0275 1443 1B                    tcs   
0276 1444 2B                    pld   
0277 1445 68                    pla   
0278 1446 8A                    txa   
0279 1447 C9 01 00              cmp   #1
0280 144A 6B                    rtl   
0281 144B
0282 144B              ;
0283 144B              ; FastFontMessageStuff
0284 144B              ; This section will contain routines that operate with the message center to add/change
0285 144B              ; the fastfont message that it finds.
0286 144B              ;
0287 144B              ;
0288 144B              GetMessage  
0289 144B              ;
0290 144B              ; This routine will be called to get the fastfont handle from the message center
0291 144B              ; if it exists.  It will set the carry if no message exists yet, if the carry is
0292 144B              ; clear then <A> and <x> will contain the fastfont handle to use,
0293 144B              ; <A> high word <X> low word
0294 144B              ;
0295 144B 64 01                 stz   <deref1
0296 144D 64 03                 stz   <deref1+2
0297 144F
0298 144F A9 0C 00              lda   #FastFontMsgRecord.size
0299 1452 A2 00 80              ldx   #attrLocked
0300 1455 20 49 15              jsr   GetALittleMem
0301 1458 B0 1C                 bcs   @NoMessage
0302 145A 85 01                 sta   <Deref1                  ; save the handle for a second...
0303 145C 86 03                 stx   <Deref1+2
0304 145E
0305 145E
0306 145E F4 02 00              pea   2                        ; get a message
0307 1461 F4 23 00              pea   FFHandleMessage          ; type of message to get
0308 1464 DA                    phx   
0309 1465 48                    pha   
0310 1466 A2 01 15 22           _MessageCenter                 ; get the proper message
0311 146D 90 09                 bcc   @GotMessage              ; if no error then continue
0312 146F
0313 146F              @NoFastFont  
0314 146F A5 01                 lda   deRef1
0315 1471 A6 03                 ldx   deRef1+2
0316 1473 20 3F 15              jsr   KillIt
0317 1476
0318 1476 38           @NoMessage sec                          ; indicate no message yet
0319 1477 60                    rts                            ; and return
0320 1478
0321 1478              @GotMessage  
0322 1478 A0 02 00              ldy   #2                       ; deref the message
0323 147B A7 01                 lda   [deref1]
0324 147D 85 05                 sta   <tempPort                ; dereference the message to get its contents
0325 147F B7 01                 lda   [deref1],y
0326 1481 85 07                 sta   TempPort+2
0327 1483
0328 1483 A0 06 00              ldy   #FastFontMsgRecord.Indicator
0329 1486 B7 05                 lda   [tempPort],y             	; now check the signature...
0330 1488 C9 E7 A5              cmp   #FFMessageIndicator
0331 148B D0 E2                 bne   @NoFastFont              	; if not proper, then someone else used my message
0332 148D
0333 148D
0334 148D              ;
0335 148D              ; At this time, we have a valid message, lets test it to see if it still has
0336 148D              ; a good handle in it!
0337 148D              ;
0338 148D A0 0A 00              ldy   #FastFontMsgRecord.Handle+2 ; recover the handle
0339 1490 B7 05                 lda   [tempPort],y
0340 1492 29 FF 00              and   #$00FF                   	; strip off high bit.
0341 1495 AA                    tax   
0342 1496 88                    dey   
0343 1497 88                    dey   
0344 1498 B7 05                 lda   [TempPort],y
0345 149A 85 05                 sta   tempPort
0346 149C 86 07                 stx   tempPort+2
0347 149E
0348 149E              ;
0349 149E              ; Is this a valid handle?
0350 149E              ;
0351 149E D4 07                 pei   tempPort+2
0352 14A0 D4 05                 pei   tempPort
0353 14A2 A2 02 1E 22           _Checkhandle 
0354 14A9 B0 C4                 bcs   @NoFastFont
0355 14AB              ;
0356 14AB              ; test to see if the handle is purged...
0357 14AB              ;
0358 14AB A7 05                 lda   [tempPort]
0359 14AD A0 02 00              ldy   #2
0360 14B0 17 05                 ora   [tempPort],y
0361 14B2 D0 09                 bne   @NotPurged
0362 14B4
0363 14B4              ;
0364 14B4              ; It was purged so kill the orphan.
0365 14B4              ;
0366 14B4 A5 05                 lda   TempPort
0367 14B6 A6 07                 ldx   TempPort+2
0368 14B8 20 3F 15              jsr   KillIt
0369 14BB 80 B2                 bra   @NoFastFont              ; tell the app we did not have a fastfont
0370 14BD              @NotPurged  
0371 14BD
0372 14BD
0373 14BD              ;
0374 14BD              ; If we get this far, then we have a proper message with the proper fastfont stuff in it
0375 14BD              ;
0376 14BD F4 00 00              pea   0                        	; set the purge level to 0
0377 14C0 A5 07 48 A5           PushLong <tempPort 
0378 14C6 A2 02 24 22           _SetPurge                      ; set it as nonpurgeable...
0379 14CD
0380 14CD              ;
0381 14CD              ; Get rid of temporary handle.
0382 14CD              ;
0383 14CD A5 01                 lda   deRef1
0384 14CF A6 03                 ldx   deRef1+2
0385 14D1 20 3F 15              jsr   KillIt
0386 14D4
0387 14D4 A5 05                 lda   TempPort                 	; Return the handle in a & x
0388 14D6 A6 07                 ldx   TempPort+2
0389 14D8
0390 14D8 18           IgnoreError clc                         ; clear the carry
0391 14D9 60                    rts                            ; and return
0392 14DA
0393 14DA
0394 14DA
0395 14DA              ;-----------------------------------------------------------
0396 14DA              ;
0397 14DA              ; SendMessage puts a fast font message record in the
0398 14DA              ; the message center.
0399 14DA              ;
0400 14DA              SendMessage  
0401 14DA
0402 14DA              ; First allocate room for our message
0403 14DA 64 09                 stz   <tempHandle
0404 14DC 64 0B                 stz   <tempHandle+2
0405 14DE
0406 14DE A9 0C 00              lda   #FastFontMsgRecord.Size
0407 14E1 A2 00 80              ldx   #attrLocked              	; locked for now
0408 14E4 20 49 15              jsr   GetALittleMem
0409 14E7 B0 EF                 bcs   IgnoreError              	; if no error continue
0410 14E9
0411 14E9 85 09                 sta   <tempHandle              	; save the handle for a second...
0412 14EB 86 0B                 stx   <tempHandle+2
0413 14ED A0 02 00              ldy   #2                       	; deref it.
0414 14F0 A7 09                 lda   [tempHandle]
0415 14F2 85 05                 sta   tempPort
0416 14F4 B7 09                 lda   [tempHandle],y
0417 14F6 85 07                 sta   tempPort+2
0418 14F8
0419 14F8 A0 06 00              ldy   #FastFontMsgRecord.Indicator ; put our values in it
0420 14FB A9 E7 A5              lda   #FFMessageIndicator
0421 14FE 97 05                 sta   [tempPort],y
0422 1500 A5 18                 lda   <Result
0423 1502 A0 08 00              ldy   #FastFontMsgRecord.Handle
0424 1505 97 05                 sta   [tempPort],y
0425 1507 C8                    iny   
0426 1508 C8                    iny   
0427 1509 A5 1A                 lda   <Result+2
0428 150B 97 05                 sta   [tempPort],y
0429 150D              ;
0430 150D              ; now that we have a message send it...
0431 150D              ;
0432 150D F4 01 00              pea   1                        ; add a message
0433 1510 F4 23 00              pea   FFHandleMessage          ; type of message to get
0434 1513 D4 0B                 pei   TempHandle+2
0435 1515 D4 09                 pei   TempHandle
0436 1517 A2 01 15 22           _MessageCenter                 ; get the proper message
0437 151E              @NoMessage  
0438 151E
0439 151E
0440 151E              ;
0441 151E              ; Get rid of temporary handle
0442 151E              ;
0443 151E A5 09                 lda   tempHandle
0444 1520 A6 0B                 ldx   tempHandle+2
0445 1522 20 3F 15              jsr   KillIt
0446 1525
0447 1525 18                    clc                            ; indicate no message yet
0448 1526 60                    rts                            ; and return
0449 1527
0450 1527 17 2A 2F 53  FFPath   DC C:'*/System/Fonts/FastFont'
0451 153F
0452 153F
0453 153F              ;-----------------------------------------------------------
0454 153F              ;
0455 153F              ; Disposes the handle passed in a & x.
0456 153F              ;
0457 153F              KillIt    
0458 153F
0459 153F DA                    phx   
0460 1540 48                    pha   
0461 1541 A2 02 10 22           _DisposeHandle 
0462 1548 60                    rts   
0463 1549
0464 1549              ;-----------------------------------------------------------
0465 1549              ;
0466 1549              ; This is a little internal routine to call the memory manager
0467 1549              ; and get a handle of size (a-reg) and attributes(x-reg).
0468 1549              ;
0469 1549 48           GetALittleMem pha   
0470 154A 48                    pha   
0471 154B F4 00 00              pea   0
0472 154E 48                    pha   
0473 154F F4 04 44              pea   FFID                     ; user id
0474 1552 DA                    phx                            ; desired attributes
0475 1553 48                    pha   
0476 1554 48                    pha   
0477 1555 A2 02 09 22           _NewHandle 
0478 155C 68                    pla   
0479 155D FA                    plx   
0480 155E 60                    rts   
0481 155F
0482 155F                       EndP 
